SET SESSION AUTHORIZATION 'DEMODATA';
/*

DAMIT ÜBERHAUPT IRGENDWAS RECHNET, MUSS DIE GRUNDEINSTELLUNG 'ENPLAN/TECHPLAN AKTIV' gesetzt werden.

Testartikel = 'W.13.N-272.371 /TPL'
Stammkarte mit 13 Arbeitsgängen (ABG-Nr. 10 bis 130) in DemoDaten.0100.Stamm.sql angelegt
                                                Berechnung
ABG  10 | KS = 'SAG-002' | 1 Arbeitsschritt   | Custom-Function  'x_800_enplan.Saegen'  | Rechnet auf Basis von 3 Kostenstellenparametern
ABG  20 | KS = 'FRA-001' | 7 Arbeitsschritte  | Maschinen-Modell 'x_800_enplan.Default' | Rechnet auf Basis des Maschinenmodells 'FRA-001' mit 2 Verbrauchern
ABG  30 | KS = 'FRA-001' | 5 Arbeitsschritte  | Maschinen-Modell 'x_800_enplan.Default'
ABG  40 | KS = 'FRA-001' | 1 Arbeitsschritt   | Maschinen-Modell 'x_800_enplan.Default'
ABG  50 | KS = 'FRA-001' | 1 Arbeitsschritt   | Maschinen-Modell 'x_800_enplan.Default'
ABG  60 | KS = 'FRA-001' | 4 Arbeitsschritt   | Maschinen-Modell 'x_800_enplan.Default'
ABG  70 | KS = 'FRA-001' | 2 Arbeitsschritte  | Maschinen-Modell 'x_800_enplan.Default'
ABG  80 | KS = 'FRA-001' | 2 Arbeitsschritte  | Maschinen-Modell 'x_800_enplan.Default'
ABG  90 | KS = 'FRA-001' | 3 Arbeitsschritte  | Maschinen-Modell 'x_800_enplan.Default'
ABG 100 | KS = 'FRA-001' | 4 Arbeitsschritte  | Maschinen-Modell 'x_800_enplan.Default'
ABG 110 | KS = 'FRA-001' | 1 Arbeitsschritt   | Maschinen-Modell 'x_800_enplan.Default'
ABG 120 | KS = 'FRA-001' | 2 Arbeitsschritte  | Maschinen-Modell 'x_800_enplan.Default'
ABG 130 | KS = 'QS-001'  | keine              | keine

*/

-- Das sieht ein bisschen wüst aus, sollte aber per Script eine Testfunktion 'Saegen' anlegen, die zum Rechnen in ABG 10 benutzt wird.

DO $RegisterTechplanSaegen$
DECLARE funcTemplate VARCHAR;
        funcScript   VARCHAR;
        funcID       INTEGER;
        tpNodeID     INTEGER;
        sanFlussID   INTEGER;
        selFlussID   INTEGER;
        versorgerID  INTEGER := (SELECT kn_id FROM epKnotenPunkt WHERE kn_krz = 'VERSORGER' ORDER BY kn_id DESC LIMIT 1);
        myFraese     VARCHAR := 'FRA-001';
        myart_nr     VARCHAR := 'W.13.N-272.371 /TPL';
        myop_ix      INTEGER := (SELECT op_ix FROM opl WHERE op_n = myart_nr ORDER BY op_ix DESC LIMIT 1);
BEGIN

-- Aus Katalog entfernen, falls die schon Funktion schon deklariert wurde
DELETE FROM DBFunction WHERE dbf_schema = 'x_800_enplan' AND dbf_name ILIKE 'Saegen';
-- Funktion selbst droppen
DROP FUNCTION IF EXISTS x_800_enplan.Saegen(INTEGER, NUMERIC);

-- Normalerweise bearbeitet der Nutzer nur das Template und das SQL-Script wird daraus generiert. Hier machen wir beides manuell.
funcTemplate:=$fTemplate$-- Variablendeklaration
Ergebnis NUMERIC;
BEGIN

  -- Vorbereiten
  &InitializeFunction

  ergebnis := o5_th * menge * techplan_ksv_w * techplan_ksv_pa;
  -- Rechnen

  -- Aufräumen
  &FinalizeFunction

  RETURN Ergebnis;
END$fTemplate$;

-- Das Funktionsscript, das normalerweise vom Form aus dem Template generiert würde.
funcScript:=$fScript$CREATE OR REPLACE FUNCTION x_800_enplan.Saegen(o5id INTEGER, menge NUMERIC) RETURNS NUMERIC AS $$
DECLARE
-- Variablendeklaration
Ergebnis NUMERIC;
BEGIN

  -- Vorbereiten
  BEGIN
    PERFORM TSystem.LogDebug( 'x_800_enplan.Saegen', 'Enter function');

    PERFORM x_800_enplan.Initialize(o5id);   -- Parameter fÃ¼r Arbeitsschritt laden (inkl. Arbeitsgang / Kostenstelle / Material / Werkzeug etc.)

    PERFORM TSystem.LogDebug( 'x_800_enplan.Saegen', 'Cache initialisiert');

  EXCEPTION WHEN others THEN BEGIN
    PERFORM TSystem.LogError( 'x_800_enplan.Saegen', Format(E'Cache-Error: %s\\r\\no5id=%s| menge=%s', SQLERRM, o5id, menge ));
  END;END;

  ergebnis := o5_th * menge * techplan_ksv_w * techplan_ksv_pa;
  -- Rechnen

  -- Aufräumen
  BEGIN

    PERFORM x_800_enplan.Finalize();   -- Cache droppen, wenn wir die oberste aufgerufene Funktion sind und keine Unterfunktion
    IF ergebnis IS NOT NULL THEN
      PERFORM TSystem.LogInfo( 'x_800_enplan.Saegen', Format(E'Ergebnis=%s' , Ergebnis));
    ELSE
      PERFORM TSystem.LogWarning( 'x_800_enplan.Saegen', 'Ergebnis ist NULL');
    END IF;

  EXCEPTION WHEN others THEN BEGIN
    PERFORM TSystem.LogError( 'x_800_enplan.Saegen', Format(E'Finalize-Error: %s\\r\\no5id=%s| menge=%s| ergebnis=%s', SQLERRM, o5id, menge, ergebnis));
  END;END;

  RETURN Ergebnis;

END
$$ LANGUAGE plpgsql SET search_path TO "$user", public, TSystem, x_800_enplan;$fScript$;

-- Wir speichern das als Funktion ab und geben beide Definitionen mit. Per Trigger an Table DBFunction wird die Funktion automatisch eingespielt
-- und HashSummen berechnet, damit später erkannt werden kann, ob die geändert wurde.
INSERT INTO DBFunction ( dbf_schema, dbf_name, dbf_group, dbf_descr, dbf_revision, dbf_readonly, dbf_user_script, dbf_script)
  VALUES ('x_800_enplan', 'Saegen','Techplan', 'Pseudo-Funktion zur Berechnung Energieaufwand beim Sägen', 1, false, funcTemplate, funcScript)
  RETURNING dbf_id INTO funcID;

-- In der Funktion werden folgende Parameter benutzt: o5_th * menge * techplan_ksv_w * techplan_ksv_pa
-- ... die müssen wir registrieren. Menge ist automatisch bekannt da Eingangsparameter.

INSERT INTO dbfunctionvars (dbv_dbf_id, dbv_typ, dbv_varname, dbv_p_category, dbv_p_name, dbv_default_value)
  VALUES (funcID, 'TPF','o5_th', 'ASK-AS', 'o5_th', '0'); -- TPF => TechPlanField -> Zeigt auf op5.o5_th.

INSERT INTO dbfunctionvars (dbv_dbf_id, dbv_typ, dbv_varname, dbv_p_category, dbv_p_name, dbv_default_value)
  VALUES (funcID, 'TPE','techplan_ksv_w', 'Wirkungsgrad-AS', 'techplan.ksv.w', '0'); -- TPE => TechPlan-EAV-Parameter der Kostenstelle

INSERT INTO dbfunctionvars (dbv_dbf_id, dbv_typ, dbv_varname, dbv_p_category, dbv_p_name, dbv_default_value)
  VALUES (funcID, 'TPE','techplan_ksv_pa', 'Anschlussleistung', 'techplan.ksv.pa', '0'); -- TPE => TechPlan-EAV-Parameter der Kostenstelle

-- Durch die Default-Parameter in Eigenschaften / Parameter wurden für jede Kostenstelle automatisch 3 Parameter angelegt. Für die Säge setzen wir Anschlussleistung und Wirkungsgrad.
UPDATE recnokeyword SET r_value = '5.00' FROM ksv
  WHERE r_dbrid     = ksv.dbrid
    AND ks_abt      = 'SAG-002'
    AND r_reg_pname = 'techplan.ksv.pa';

UPDATE recnokeyword SET r_value = '0.5' FROM ksv
  WHERE r_dbrid     = ksv.dbrid
    AND ks_abt      = 'SAG-002'
    AND r_reg_pname = 'techplan.ksv.w';



---------------------------------------------------------------------------------------------------------------------

-- Basiseintrag für Maschinenmodell der Fräsmaschine 'FRA-001'
INSERT INTO epknotenpunkt (kn_knt_id, kn_krz, kn_bez, kn_ks, kn_inplan, kn_calcstep, kn_calcpoolabg)
  VALUES  (0, myFraese, myFraese||'.Modell', myFraese, true, 0, false)
  RETURNING kn_id INTO tpNodeID;

-- Leistungsdaten für Spindelantriebe der Fräsmaschine im Betriebzustand
INSERT INTO epfluss (fl_krz, fl_med_id, fl_bert_id, fl_bez, fl_kn_id, fl_isausgang, fl_source, fl_z_id, fl_calcstep, fl_resulttype)
  VALUES ('SAN', 1,1,'Spindelantriebe', tpNodeID, false, versorgerID, 1,0,200)
  RETURNING fl_id INTO sanFlussID;

-- Spindel-Standby: 0 kw
INSERT INTO epknotenparameter (knpar_kn_id, knpar_bez, knpar_varname, knpar_defaultwert, knpar_me, knpar_copyforabg, knpar_bert_id, knpar_bzu_id, knpar_fl_id)
  VALUES (tpNodeID, 'SAN','SAN.AVG.PS',0,98,FALSE,0,'S', sanFlussID);
-- Spindel-Rüsten: 0.5 kw
INSERT INTO epknotenparameter (knpar_kn_id, knpar_bez, knpar_varname, knpar_defaultwert, knpar_me, knpar_copyforabg, knpar_bert_id, knpar_bzu_id, knpar_fl_id)
  VALUES (tpNodeID, 'SAN','SAN.AVG.PR',0.5,98,FALSE,0,'R', sanFlussID);
-- Spindel-Hauptzeit: 5 kw
INSERT INTO epknotenparameter (knpar_kn_id, knpar_bez, knpar_varname, knpar_defaultwert, knpar_me, knpar_copyforabg, knpar_bert_id, knpar_bzu_id, knpar_fl_id)
  VALUES (tpNodeID, 'SAN','SAN.AVG.PH',5.0,98,FALSE,0,'H', sanFlussID);
-- Spindel-Nebenzeit: 0.5 kw
INSERT INTO epknotenparameter (knpar_kn_id, knpar_bez, knpar_varname, knpar_defaultwert, knpar_me, knpar_copyforabg, knpar_bert_id, knpar_bzu_id, knpar_fl_id)
  VALUES (tpNodeID, 'SAN','SAN.AVG.PN',0.5,98,FALSE,0,'N', sanFlussID);


INSERT INTO epfluss (fl_krz, fl_med_id, fl_bert_id, fl_bez, fl_kn_id, fl_isausgang, fl_source, fl_z_id, fl_calcstep, fl_resulttype)
  VALUES ('SEL', 1,1,'Steuerelektronik', tpNodeID, false, versorgerID, 1,0,200)
  RETURNING fl_id INTO selFlussID;

-- Leistungsdaten der Steuerung immer 0.5 kw
INSERT INTO epknotenparameter (knpar_kn_id, knpar_bez, knpar_varname, knpar_defaultwert, knpar_me, knpar_copyforabg, knpar_bert_id, knpar_bzu_id, knpar_fl_id)
  VALUES (tpNodeID, 'SEL','SEL.AVG.PS',0.5,98,FALSE,0,'S', selFlussID);
--
INSERT INTO epknotenparameter (knpar_kn_id, knpar_bez, knpar_varname, knpar_defaultwert, knpar_me, knpar_copyforabg, knpar_bert_id, knpar_bzu_id, knpar_fl_id)
  VALUES (tpNodeID, 'SSEL','SEL.AVG.PR',0.5,98,FALSE,0,'R', selFlussID);
--
INSERT INTO epknotenparameter (knpar_kn_id, knpar_bez, knpar_varname, knpar_defaultwert, knpar_me, knpar_copyforabg, knpar_bert_id, knpar_bzu_id, knpar_fl_id)
  VALUES (tpNodeID, 'SEL','SEL.AVG.PH',0.5,98,FALSE,0,'H', selFlussID);
--
INSERT INTO epknotenparameter (knpar_kn_id, knpar_bez, knpar_varname, knpar_defaultwert, knpar_me, knpar_copyforabg, knpar_bert_id, knpar_bzu_id, knpar_fl_id)
  VALUES (tpNodeID, 'SEL','SEL.AVG.PN',0.5,98,FALSE,0,'N', selFlussID);


  ---------------------------------------------------------------------------------------------------------------------

-- Arbeitsgang 10 / Schritt 10 bekommt diese Funktion zum Berechnen zugewiesen
UPDATE op5 SET o5_fert_prozess = 'Saegen'
  FROM op2 WHERE o5_o2_id = o2_id AND o2_ks = 'SAG-002' AND o2_ix = myop_ix;

-- Alle anderen Arbeitsschritte werden mit dem Default-Modell durchgerechnet
UPDATE op5 SET o5_fert_prozess = 'Default'
  FROM op2 WHERE o5_o2_id = o2_id AND o2_ks = 'FRA-001' AND o2_ix = myop_ix;

END $RegisterTechplanSaegen$;

RESET SESSION AUTHORIZATION;
